clear
echo "StayLinked Server Install Script for Linux"
echo

# Validate that 'stay-linked' folder does not exist
if [ -d stay-linked ]; then
	echo "INSTALL ERROR!"
	echo "The 'stay-linked' directory already exists as a subfolder of '$PWD'. It appears that the StayLinked Server is already installed on this machine. We recommend running the server upgrade instead of the install."
	exit 0
fi

# Validate that install tar is in the same folder as the script
if [ ! -e staylinked_linux.tar ]; then
	echo "INSTALL ERROR!"
	echo "The 'staylinked_linux.tar' file was not found in '$PWD'. Please make sure that the 'staylinked_linux.tar' file is located in the '$PWD' folder."
	exit 0
fi

# Confirm install with user
echo "Install of StayLinked Server can proceed, press ENTER to continue"
read var1

# Extract the entire server
tar -ixvf staylinked_linux.tar

echo
echo "StayLinked Server Install is completed."
