#!/bin/ksh -vx

getch(){
  typeset TMP_GETCH
  typeset STAT_GETCH="0"
  stty raw
  TMP_GETCH=`dd bs=1 count=1 2> /dev/null`
  STAT_GETCH="${?}"
  stty -raw
  print -r -- "${TMP_GETCH}"
  return ${STAT_GETCH}
}

while true

do
   clear
   echo "Select API Test"
   echo "-------------------"   
   echo "1. Sess Properties"
   echo "2. Send File to Dev"
   echo "3. Rtrv Device File"
   echo "4. Send Message"
   echo "5. Restart Client"
   echo "6. Reboot Device"
   echo "7. Desconnect Dev"
   echo "8. Terminate Sess"         
   echo "9. Init Radio Stats"
   echo "A. Init Echo Test"   
   echo "B. Reload Dev Cnfig"
   echo "C. Send Rmt Command"   
   echo "E. Exit\n"
   
   menuselect=`getch`
   
   clear   
   
   case $menuselect in
   
   1) print " ~API01"
      oldIFS=$IFS
      IFS="~"
      read dummy sessionID deviceType deviceName ipAddress macAddress sessionStart lastActivity clientVersion deviceHeight deviceWidth userID
      clear
      echo "Session_Properties"
      echo "--------------------"      
      echo "SID:" $sessionID
      echo "DTP:" $deviceType
      echo "DNM:" $deviceName
      echo "IPA:" $ipAddress
      echo "MAC:" $macAddress
      echo "STR:" $sessionStart
      echo "ACT:" $lastActivity
      echo "VER:" $clientVersion
      echo "HGT:" $deviceHeight
      echo "WID:" $deviceWidth
      echo "USR:" $userID 
      IFS=$oldIFS
      read prompt;;  
        
   2) clear
      echo "Send File to Device"
      echo "--------------------"
      echo "Lcl File:"
      read lclfile
      echo "New File:"
      read newfile
      echo ""
      echo "Show Sts: Y/N" 
      showsts=`getch`
      if [ $showsts = y ] || [ $showsts = Y ] ; then
        showsts="Y"
      else
        showsts="N"
      fi
      clear
      print " ~API02 ~" $lclfile "~" $newfile "~ [enter]" "~ [enter]" "~" $showsts "~"
      read response
      clear
      echo "Results:"
      echo "--------------------"
      echo ""
      print $response
      read prompt;;
   
   3) clear
      echo "Rx File from Device"
      echo "--------------------"
      echo "Rmt File:"
      read rmtfile
      echo "New File:"
      read newfile
      echo ""
      echo "Show sts: Y/N" 
      showsts=`getch`
      if [ $showsts = y ] || [ $showsts = Y ] ; then
        showsts="Y"
      else
        showsts="N"
      fi
      echo ""
      echo "Clr File: Y/N" 
      clrfile=`getch`
      if [ $clrfile = y ] || [ $clrfile = Y ] ; then
        clrfile="Y"
      else
        clrfile="N"
      fi      
      clear
      print " ~API03 ~" $rmtfile "~" $newfile "~ [enter]" "~ [enter]" "~" $showsts "~" $clrfile "~"
      read response
      clear
      echo "Results:"
      echo "--------------------"
      echo ""
      echo $response
      read prompt;;

   4) clear
      echo "Send Msg to Device"
      echo "--------------------"
      echo ""
      echo "Enter the message:"
      read message
      print " ~AP04 ~" $message;; 
   
      
   5) clear
      echo " Restart the Client"
      echo "--------------------"
      echo ""
      echo "Are You Sure? Y/N"
      str=`getch`
      if [ $str = y ] || [ $str = Y ] ; then
      	clear
      	print " ~API05"
      	read prompt
      fi;;
   
   6) clear
      echo "Reboot the Device"
      echo "--------------------"
      echo ""
      echo "Are You Sure? Y/N"
      str=`getch`
      if [ $str = y ] || [ $str = Y ] ; then
      	clear
      	print " ~API06"
      	read prompt
      fi;;

   7) clear
      echo "Disconnect Device"
      echo "--------------------"
      echo ""
      echo "Are You Sure? Y/N"
      str=`getch`
      if [ $str = y ] || [ $str = Y ] ; then
      	clear
      	print " ~API07"
      	read prompt
      fi;;

   8) clear
      echo "Terminate Session"
      echo "--------------------"
      echo ""         
      echo "Are You Sure? Y/N"
      str=`getch`
      if [ $str = y ] || [ $str = Y ] ; then
      	clear
      	print " ~API08"
      	read prompt
      fi;;

   9) clear
      echo "Initiate Radio Stats"
      echo "--------------------"
      echo ""
      echo "Are You Sure? Y/N"
      str=`getch`
      if [ $str = y ] || [ $str = Y ] ; then
      	clear
      	print " ~API09"
      	read prompt
      fi;;
      
   a|A) clear
      echo "Initiate Echo Test"
      echo "--------------------"
      echo ""
      echo "Are You Sure? Y/N"
      str=`getch`
      if [ $str = y ] || [ $str = Y ] ; then
      	clear
      	print " ~API10"
      	read prompt
      fi;;

   b|B) clear
      echo "Reload Dev Config"
      echo "--------------------"
      echo ""   
      echo "Are You Sure? Y/N"
      str=`getch`
      if [ $str = y ] || [ $str = Y ] ; then
      	clear
      	print " ~API11"
      	read prompt
      fi;;
   
   c|C) clear
      echo "Send Cmd to Device"
      echo "--------------------"
      echo ""
      echo "Command to Send:"
      read cmd
      echo ""
      echo "Prompt: Y/N" 
      SCDprompt=`getch`
      if [ $SCDprompt = y ] || [ $SCDprompt = Y ] ; then
        SCDprompt="Y"
      else
        SCDprompt="N"
      fi
      echo ""
      echo "Clear.: Y/N" 
      SCDclear=`getch`
      if [ $SCDclear = y ] || [ $SCDclear = Y ] ; then
        SCDclear="Y"
      else
        SCDclear="N"
      fi  
      echo ""
      echo "Wait..: Y/N" 
      SCDwait=`getch`
      if [ $SCDwait = y ] || [ $SCDwait = Y ] ; then
        SCDwait="Y"
      else
        SCDwait="N"
      fi             
      clear
      print " ~API12 ~" $cmd "~" $SCDprompt "~" $SCDclear "~" $SCDwait "~"
      read response;;
                                                
   e|E)	exit;;
   
   *) 
      echo ""
      echo "Invalid selection,"
      echo "try again"
      read prompt;;
   
   esac

print $menuselect

done

exit 0
